unit CutDown;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ExtCtrls, GMP_Cutdown, ComCtrls;

const
     CANDLE = 1;
     STICK = 2;
     NERFERTY = 3;

type
  TForm1 = class(TForm)
    Panel1: TPanel;
    BButPrev: TBitBtn;
    BButNext: TBitBtn;
    BitBtn3: TBitBtn;
    BitBtn4: TBitBtn;
    Timer1: TTimer;
    GMP3DA: TGMPCutdown;
    Panel2: TPanel;
    REditInventory: TRichEdit;
    procedure FormShow(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure BitBtn4Click(Sender: TObject);
    procedure BButNextClick(Sender: TObject);
    procedure BButPrevClick(Sender: TObject);
    procedure FormDblClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    CamPos, CamRot : TPoint3D; {Defines an X,Y,Z of type single}
    LightPos : Tpos4;          {Define an X,Y,Z,W of type single}
    Item : Integer;            {Tell me which model to draw}
    Rot : Single;
    Procedure DrawTheModel;    {A procedure for draw all the different models}
  end;

var
  Form1: TForm1;

implementation

uses RightPanel;

{$R *.DFM}

procedure TForm1.DrawTheModel;
var
Position : TPoint3D;
vertex : array [0..2] of TPoint3D;
begin
     Case Item of
     0 :  begin
               {I only call ClearModelMatrix Once because I can use the accumulative
               rotation results rather than reinitialise the model matrix for every
               single object!}
               GMP3DA.ClearModelMatrix;

               {This is the main rotation, everything below is now rotated on the Y axis}
               GMP3DA.SetPosition(0,1.2,0);
               GMP3DA.SetRotation(0,1,0,Rot);
               Rot := Rot + 10;
               If Rot > 360 then Rot := 10;

               {Below we do the spikes}
               GMP3DA.SetBuiltInMaterial('Gold');
               GMP3DA.GMPTet(1.2);
               GMP3DA.SetRotation(0,1,0, 45); {Rotates along the Y axis 45 degrees}
               GMP3DA.GMPTet(1.2);
               GMP3DA.SetRotation(0,1,0, 45); {Rotates another 45 degrees on Y}
               GMP3DA.GMPTet(1.2);
               GMP3DA.SetRotation(0,1,0, 45);  {Rotates another 45 degrees on Y}
               GMP3DA.GMPTet(1.2);

               {The Main Shaft}
               GMP3DA.SetBuiltInMaterial('Silver');
               GMP3DA.GMPCylinder(0.3, 1.9);  {First value is radius, then height}

               {This sets the Chains}
               GMP3DA.SetBuiltInMaterial('Gold');
               GMP3DA.SetPosition(0,-1,0);   {Remember that as no call to ClearModelMatrix}
               GMP3DA.GMPTorus(0.1, 0.3);    {is made all positional and rotational changes}
               GMP3DA.SetPosition(0,-0.3,0); {are accumulative!}
               GMP3DA.SetRotation(0,1,0, 90);
               GMP3DA.GMPTorus(0.07, 0.25);
               GMP3DA.SetPosition(0,-0.3,0);
               GMP3DA.SetRotation(0,1,0, 90);
               GMP3DA.GMPTorus(0.07, 0.25);
               GMP3DA.SetPosition(0,-0.3,0);
               GMP3DA.SetRotation(0,1,0, 90);
               GMP3DA.SetRotation(1,0,0, 30); {This one now makes the chains bend off}
               GMP3DA.GMPTorus(0.07, 0.25);   {in a different direction}
               GMP3DA.SetPosition(0,-0.3,0);
               GMP3DA.SetRotation(0,1,0, 90);
               GMP3DA.GMPTorus(0.07, 0.25);
               GMP3DA.SetPosition(0,-0.3,0);
               GMP3DA.SetRotation(0,1,0, 90);
               GMP3DA.GMPTorus(0.07, 0.25);

               {And finally the handle}
               GMP3DA.SetBuiltInMaterial('ShinyBrass');
               GMP3DA.SetPosition(0,-1.05,0);
               GMP3DA.GMPCylinder(0.25, 1.3);

          end;
     1 :  begin
               GMP3DA.ClearModelMatrix;

               {This is the main rotation every below is now rotated on the Y axis}
               GMP3DA.SetBuiltInMaterial('Pewter');
               GMP3DA.SetPosition(0,0.0,-10);
               GMP3DA.SetRotation(0,1,0,-Rot);
               Rot := Rot + 10;
               If Rot > 360 then Rot := 10;

               {Now draw the object}
               GMP3DA.SetRotation(1,0,0,-90); {The object is held in a raw file and is}
                                              {incorrectly oriented.  So the first call}
                                              {to SetRotation corrects this}
               GMP3DA.DrawCompiledrawObject(Stick);  {Draws the candle base}
               GMP3DA.SetBuiltInMaterial('ebony');
               GMP3DA.SetCurrentTexture('yum.BMP', True);
               GMP3DA.DrawCompiledRawObject(Candle);    {Draws the candles}
               GMP3DA.GMPLoadAutoTexture('', False);

          end;
     2 :  begin
               GMP3DA.ClearModelMatrix;

               {This is the main rotation every below is now rotated on the X axis}
               GMP3DA.SetBuiltInMaterial('Gold');
               GMP3DA.SetPosition(0,0.0,-5);
               GMP3DA.SetRotation(1,0,0,-Rot);
               Rot := Rot + 10;
               If Rot > 360 then Rot := 10;

               {Now draw the object}
               GMP3DA.GMPIcos(1);
               GMP3DA.SetBuiltInMaterial('Silver');
               GMP3DA.SetPosition(-2,0,0);
               GMP3DA.GMPCube(1);
               GMP3DA.SetBuiltInMaterial('Ebony');
               GMP3DA.SetPosition(4,0,0);
               GMP3DA.GMPIcos(1);
               GMP3DA.SetBuiltInMaterial('ShinyBrass');
               GMP3DA.SetPosition(2,0,0);
               GMP3DA.GMPDod(1);
               GMP3DA.SetBuiltInMaterial('Pewter');
               GMP3DA.SetPosition(-8,0,0);
               GMP3DA.GMPOct(1);
               GMP3DA.SetBuiltInMaterial('Chalk');
               GMP3DA.SetPosition(2,2,0);
               GMP3DA.GMPTorus(0.3, 1);
               GMP3DA.SetBuiltInMaterial('BluePlastic');
               GMP3DA.SetPosition(0,-4,0);
               GMP3DA.GMPTet(1);
               GMP3DA.SetBuiltInMaterial('BlackRubber');
               GMP3DA.SetPosition(0,0,2);
               GMP3DA.GMPSphere(1);
               GMP3DA.SetBuiltInMaterial('Emerald');
               GMP3DA.SetPosition(0,4,0);
               GMP3DA.GMPSphere(1);
               GMP3DA.SetBuiltInMaterial('Ruby');
               GMP3DA.SetPosition(0,-2,0);
               GMP3DA.GMPSphere(1);



          end;
    3 :  begin
               GMP3DA.ClearModelMatrix;

               {This is the main rotation every below is now rotated on the Y axis}
               GMP3DA.SetBuiltInMaterial('Silver');
{               GMP3DA.GMPLoadAutoTexture('pinkmarb.bmp', true);}
               GMP3DA.SetCurrentTexture('grass.bmp', true);

               GMP3DA.SetPosition(0,-1.5,-8);
               GMP3DA.SetRotation(0,1,0,-Rot);
               Rot := Rot + 10;
               If Rot > 360 then Rot := 10;

               {Now draw the object}
               GMP3DA.DrawCompiledrawObject(Nerferty);
{               GMP3DA.GMPLoadAutoTexture('', False);}
               GMP3DA.SetCurrentTexture('', False);

               GMP3DA.SetBuiltInMaterial('Ebony');
               GMP3DA.SetPosition(0,-3.5,-0.6);
               GMP3DA.GMPBox(8,1,8);
               GMP3DA.SetPosition(0,0,3.95);
               GMP3DA.SetBuiltInMaterial('Gold');
               GMP3DA.GMPBox(2, 0.5, 0.2);
               GMP3DA.SetPosition(3.6,8,-0.2);
               GMP3DA.GMPCylinder(0.15, 8.7);
               GMP3DA.SetPosition(0,0,-7.5);
               GMP3DA.GMPCylinder(0.15, 8.7);
               GMP3DA.SetPosition(-7.2,0,0);
               GMP3DA.GMPCylinder(0.15, 8.7);
               GMP3DA.SetPosition(0,0,7.5);
               GMP3DA.GMPCylinder(0.15, 8.7);
               GMP3DA.SetPosition(0,1.3,0);
               GMP3DA.GMPSphere(0.3);
               GMP3DA.SetPosition(7.2,0,0);
               GMP3DA.GMPSphere(0.3);
               GMP3DA.SetPosition(0,0,-7.5);
               GMP3DA.GMPSphere(0.3);
               GMP3DA.SetPosition(-7.2,0,0);
               GMP3DA.GMPSphere(0.3);
               GMP3DA.SetRotation(0,0,1, 90);
               GMP3DA.SetPosition(0,-0.9,0);
               GMP3DA.GMPCylinder(0.15, 7.5);
               GMP3DA.SetPosition(0,0,7.5);
               GMP3DA.GMPCylinder(0.15, 7.5);
               GMP3DA.SetRotation(1,0,0, 90);
               GMP3DA.SetPosition(0,-0.9,-0.9);
               GMP3DA.GMPCylinder(0.15, 7.5);
               GMP3DA.SetPosition(0,0,7.2);
               GMP3DA.GMPCylinder(0.15, 7.5);
{               GMP3DA.EnableFogging(True);}





          end;
    4     : begin
                 GMP3DA.ClearModelMatrix;
               {This is the main rotation every below is now rotated on the Y axis}
               GMP3DA.SetRotation(0,1,0,-Rot);
               Rot := Rot + 10;
               If Rot > 360 then Rot := 10;


                 GMP3DA.SetPosition(-1, 0, -1);
                 GMP3DA.SetBuiltInMaterial('Silver');
                 GMP3DA.GMPLoadAutoTexture('wmarble.bmp', true);
                 GMP3DA.GMPSphere(1);
                 GMP3DA.GMPLoadAutoTexture('', false);
            end;
    5     : begin
                 GMP3DA.ClearModelMatrix;
               {This is the main rotation every below is now rotated on the Y axis}
               GMP3DA.SetPosition(0, 0, 3);
               GMP3DA.SetRotation(0,0,1,rot);
               GMP3DA.SetCurrentTexture('apoc.bmp', true);
               Rot := Rot + 10;
               If Rot > 360 then Rot := 1;
               Vertex[0].X := 0;
               Vertex[0].Y := 0.5;
               Vertex[0].Z := 0;

               Vertex[2].X := 0.5;
               Vertex[2].Y := - 0.5;
               Vertex[2].Z := 0;

               Vertex[1].X := -0.5;
               Vertex[1].Y := -0.5;
               Vertex[1].Z := 0;



                 GMP3DA.SetBuiltInMaterial('Silver');
                 GMP3DA.GMPTexturedTriangle(Vertex);
                 GMP3DA.SetCurrentTexture('', false);
            end;




     end;
end;

procedure TForm1.FormShow(Sender: TObject);
begin
     {Initialise the camera position and rotation}
     CamPos.X := 0;
     CamPos.Y := 0;
     CamPos.Z := -5;  {Moves camera 5 backwards }
     CamRot.X := 0;
     CamRot.Y := 0;
     CamRot.Z := 0;
     Rot := 0;

     {LightPosition}
     LightPos.x := 1; {Will set light to world coordinates (5,10,10}
     LightPos.Y := 10;
     LightPos.Z := 10;
     LightPos.W := 1;

     {This must be called first!}
     GMP3DA.Start3D := True;

     {Now set the position of your viewing window within your Delphi window}
     GMP3DA.SetViewPort(Panel2.Width, 47, Form1.Width - Panel2.Width , Form1.Height - Panel1.Height);

     {Set up your camera position and rotation}
     GMP3DA.SetCamera(CamPos, CamRot);

     {Set up a light}
     GMP3DA.SetLight(True,LightPos, GMP3DA.Ambient_Default, GMP3DA.Diffuse_Default, GMP3DA.Specular_Default);

     {This loads in the first item descritpion}
     Item := 0;
     REditInventory.Lines.Loadfromfile('Ball&Chain.rtf');

     {Loads both objects into GMP3DA}
     GMP3DA.Load_Compile_rawObject('candle.raw', CANDLE);
     GMP3DA.Load_Compile_rawObject('sticks.raw', STICK);
     GMP3DA.Load_Compile_rawObject('nerferty.raw', NERFERTY);

     {Set off the timer}
     Timer1.Enabled := True;

end;

procedure TForm1.Timer1Timer(Sender: TObject);
const
     FrameRate : Single = 0.0;
     Counter : Integer = 0;
     First : DWord = 0;
     Last : DWord = 0;
begin
     {Clear the BackBuffer}
     GMP3DA.ClearBuffer;

     {Draw the appropriate model}
     DrawTheModel;

     {Show the back buffer}
     GMP3DA.SwapBackBuffer;
     Inc(Counter);
     If counter = 10 then
     begin
          last := GetTickCount;
          Framerate := (Last - First) / 1000;
          Form1.caption := 'Frame Rate : ' + FloatToStr(10 / FrameRate) + ' per sec';
          Counter := 0;
          First := GetTickCount;

     end;


end;

procedure TForm1.BitBtn4Click(Sender: TObject);
begin
close;
end;

procedure TForm1.BButNextClick(Sender: TObject);
begin

     {This just selects the appropriate Text to display}
     Inc(Item);
     case Item of
     0 : REditInventory.Lines.Loadfromfile('Ball&Chain.rtf');
     1 : REditInventory.Lines.LoadFromFile('Shield.rtf');
     2 : REditInventory.Lines.LoadFromFile('Default.rtf');
     end;
end;

procedure TForm1.BButPrevClick(Sender: TObject);
begin

     {This just selects the appropriate Text to display}
     dec(Item);
     case Item of
     0 : REditInventory.Lines.Loadfromfile('Ball&Chain.rtf');
     1 : REditInventory.Lines.LoadFromFile('Shield.rtf');
     2 : REditInventory.Lines.LoadFromFile('Default.rtf');
     end;

end;

procedure TForm1.FormDblClick(Sender: TObject);
const
     Choice : Boolean = TRUE;
begin

     {This toggles smooth and flat shading}
     GMP3DA.GMPSMOOTH( not Choice);
     Choice := not Choice;
end;

end.
